﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace OpenAPI_App_Manager
{
    public partial class IPInput : TextBox
    {
        public IPInput()
        {
        }

        protected override void OnKeyPress(KeyPressEventArgs e)
        {
            if (!char.IsDigit(e.KeyChar) && e.KeyChar != '.')
                return;
            base.OnKeyPress(e);
        }

        protected override void OnTextChanged(EventArgs e)
        {
            int iPos = this.SelectionStart;
            string szNew = string.Empty;
            foreach (char c in this.Text)
                if (char.IsDigit(c) || c == '.')
                    szNew += c;

            List<int> lOctets = new List<int>();
            int iStartOfOctet = 0;
            for (int i = 0; i < szNew.Length; i++)
            {
                if (szNew[i] == '.')
                {
                    if (szNew[i - 1] == '.')
                        continue;

                    lOctets.Add(int.Parse(szNew.Substring(iStartOfOctet, i - iStartOfOctet)));
                    iStartOfOctet = i + 1;
                }
            }
            bool bAddDot = (szNew.EndsWith("."));
            if (szNew!=string.Empty && !szNew.EndsWith("."))
                lOctets.Add(int.Parse(szNew.Substring(szNew.LastIndexOf(".") + 1)));

            List<int> lOctetsBetter = new List<int>();
            int iCount = 0;
            foreach (int iOctet in lOctets)
            {
                int iNewOctet = iOctet;

                iCount++;
                if (iNewOctet > 255) iNewOctet = 255;
                lOctetsBetter.Add(iNewOctet);
                if (iCount == 4)
                    break;
            }
            if (lOctetsBetter.Count > 0 && lOctetsBetter[0] == 0)
                lOctetsBetter[0] = 1;

            szNew = string.Empty;
            foreach (int iOctet in lOctetsBetter)
                szNew += iOctet.ToString() + ".";

            if ((szNew.EndsWith(".") && !bAddDot) || lOctetsBetter.Count == 4)
                szNew = szNew.Substring(0, szNew.Length - 1);

            this.Text = szNew;
            this.Select(iPos, 0);

            base.OnTextChanged(e);
        }
    }
}
